 ; Ŀ
 ;   Mama - apply wipeouts to specified text strings.                      
 ;   Copyright 2004, 2005, 2007 - 2009 by Rocket Software Ltd.             
 ;   If you're religious, everything will be on the final exam.            
 ; 

 ; Ŀ
 ;   Mag - make a randomly named group.                                    
 ;   Argument: Ss, a selection set of stuff to group.                      
 ;   Returns a group name.                                                 
 ; 
 (DEFUN MAG (ss / namm)
 ; Ŀ
 ;   Concoct a group name.                                                 
 ; 
  (setq lup (getvar "luprec"))              ; don't make local
  (setvar "luprec" 8)
  (setq namm (rtos (getvar "date")))        ; get exact time
  (setq namm (strcat "G" (substr namm 9)))
  (setvar "luprec" lup)
 ; Ŀ
 ;   Make the group.                                                       
 ; 
  (command ".group" "" namm "" ss "")
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
 namm)
 ; Ŀ
 ;   Mag end.                                                              
 ; 

 ; Ŀ
 ;   Soldie - wipe out an area slightly larger than a text entity.         
 ;   Arguments: Enam, a text entity ename.                                 
 ;              Cutdis, the wipeout clearance distance.                    
 ; 
 (DEFUN SOLDIE (enam cutdis / entt tblst rota cc dd bheigt bwidth llangg
                               lldist ll ul lr ur lll uul llr uur enamwp ss)
 ; Ŀ
 ;   Get the entity data list.                                             
 ; 
  (setq entt (entget enam))
  (setq tblst (textbox entt))
 ; Ŀ
 ;   Get the entity corner points.                                         
 ; 
  (setq rota (cdr (assoc 50 entt)))
  (setq cc (car tblst))                    ; ll offset from 10 of text
  (setq dd (cadr tblst))                   ; ur offset from 10 of text
  (setq bheigt (- (cadr dd) (cadr cc)))
  (setq bwidth (- (car dd) (car cc)))
  (setq llangg (angle (list 0 0) cc))
  (setq lldist (distance (list 0 0) cc))
  (setq ll (polar (cdr (assoc 10 entt)) (+ llangg rota) lldist))
  (setq ul (polar ll (+ rota (/ pi 2)) bheigt))
  (setq lr (polar ll rota bwidth))
  (setq ur (polar lr (+ rota (/ pi 2)) bheigt))
 ; Ŀ
 ;   Make the wipeout corner points.                                       
 ; 
  (setq lll (polar ll (+ rota (* pi 1.25)) (* (sqrt 2) cutdis)))
  (setq uul (polar ul (+ rota (* pi 0.75)) (* (sqrt 2) cutdis)))
  (setq llr (polar lr (+ rota (* pi 1.75)) (* (sqrt 2) cutdis)))
  (setq uur (polar ur (+ rota (* pi 0.25)) (* (sqrt 2) cutdis)))
 ; Ŀ
 ;   Draw a wipeout.                                                       
 ;   Calling Wipeout as a command works in 2005 but only intermittently    
 ;   in 2002, presumably because the lisp routine has been replaced        
 ;   with an internal command.                                             
 ; 
  (if (> (read (substr (getvar "acadver") 1 2)) 14)
      (command ".wipeout" lll uul uur llr "")
      (progn
           (c:wipeout)
           (command lll uul uur llr "")))
  (setq enamwp (entlast))
 ; Ŀ
 ;   Bring the text entity to the front.                                   
 ; 
  (command "draworder" enam "" "front")
 ; Ŀ
 ;   Group it.                                                             
 ; 
  (setq ss (ssadd enam))
  (ssadd enamwp ss)
  (mag ss)
 (princ))
 ; Ŀ
 ;   Soldie end.                                                           
 ; 

 ; Ŀ
 ;   Mama.                                                                 
 ; 
 (DEFUN C:MAMA (/ *error* osm snapp clayer ss num enam entt)
  (setvar "cmdecho" 0)
  (command "undo" "be")
 ; Ŀ
 ;   Save a few settings.                                                  
 ; 
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq osm (getvar "osmode"))
  (setvar "osmode" 0)
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
  (setq clayer (getvar "clayer"))
 ; Ŀ
 ;   Make an error handler.                                                
 ; 
  (defun *error* (shk)
   (setvar "osmode" osm)
   (setvar "snapmode" snapp)
   (setvar "clayer" clayer)
   (command ".undo" "end")
   (if shk (print shk))
  (princ))
 ; Ŀ
 ;   Get some text entities.                                               
 ; 
  (prompt "\nSelect Text or <All>: ")
  (if (null (setq ss (ssget (list (cons 0 "text")))))
      (setq ss (ssget "x" (list (cons 0 "text")))))
 ; Ŀ
 ;   Get the text entity in question.  (There should be only one.)         
 ;   Call Noul to kill the underline lwpolyline, and Soldie to make the    
 ;   wipeout and remove underline lines.                                   
 ; 
  (setq num 0)
  (while (setq enam (ssname ss num))
         (setq num (1+ num))
 ; Ŀ
 ;   Make the layer containing the entity in question current.             
 ; 
         (setvar "clayer" (cdr (assoc 8 (setq entt (entget enam)))))
         (soldie enam (* 0.5 (cdr (assoc 40 entt)))))
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
;  (command "wipeout" "f" "off")
  (*error* ())
 (princ))